# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 541-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53231);
 script_bugtraq_id(11021);
 script_cve_id("CVE-2004-0781");
 script_version ("$");
 name = "Debian Security Advisory DSA 541-1 (icecast-server)";
 script_name(name);

 desc = "The remote host is missing an update to icecast-server
announced via advisory DSA 541-1.

Markus Wrle discovered a cross site scripting problem in
status-display (list.cgi) of the icecast internal webserver, an MPEG
layer III streaming server.  The UserAgent variable is not properly
html_escaped so that an attacker could cause the client to execute
arbitrary Java script commands.


For the stable distribution (woody) this problem has been fixed in
version 1.3.11-4.2.

For the unstable distribution (sid) this problem has been fixed in
version 1.3.12-8.

We recommend that you upgrade your icecast-server package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20541-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 541-1 (icecast-server)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"icecast-server", ver:"1.3.11-4.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
