# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 544-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53234);
 script_bugtraq_id(11153);
 script_cve_id("CVE-2004-0559");
 script_version ("$");
 name = "Debian Security Advisory DSA 544-1 (webmin)";
 script_name(name);

 desc = "The remote host is missing an update to webmin
announced via advisory DSA 544-1.

Ludwig Nussel discovered a problem in webmin, a web-based
administration toolkit.  A temporary directory was used but without
checking for the previous owner.  This could allow an attacker to
create the directory and place dangerous symbolic links inside.

For the stable distribution (woody) this problem has been fixed in
version 0.94-7woody3.

For the unstable distribution (sid) this problem has been fixed in
version 1.160-1 of webmin and 1.090-1 of usermin.

We recommend that you upgrade your webmin packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20544-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 544-1 (webmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"webmin-apache", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-bind8", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-burner", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cluster-software", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cluster-useradmin", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-core", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-cpan", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-dhcpd", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-exports", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-fetchmail", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-heartbeat", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-inetd", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-jabber", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-lpadmin", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-mon", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-mysql", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-nis", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-postfix", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-postgresql", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-ppp", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-qmailadmin", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-quota", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-raid", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-samba", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-sendmail", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-software", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-squid", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-sshd", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-ssl", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-status", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-stunnel", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-wuftpd", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-xinetd", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"webmin-grub", ver:"0.94-7woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
