# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 563-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53252);
 script_bugtraq_id(11347);
 script_cve_id("CVE-2004-0884");
 script_version ("$");
 name = "Debian Security Advisory DSA 563-2 (cyrus-sasl)";
 script_name(name);

 desc = "The remote host is missing an update to cyrus-sasl
announced via advisory DSA 563-2.

This advisory corrects DSA 563-1 which contained a library that caused
other programs to fail unindented.

For the stable distribution (woody) this problem has been fixed in
version 1.5.27-3woody3.

For reference the advisory text follows:

A vulnerability has been discovered in the Cyrus implementation of
the SASL library, the Simple Authentication and Security Layer, a
method for adding authentication support to connection-based
protocols.  The library honors the environment variable SASL_PATH
blindly, which allows a local user to link against a malicious
library to run arbitrary code with the privileges of a setuid or
setgid application.

For the unstable distribution (sid) this problem has been fixed in
version 1.5.28-6.2 of cyrus-sasl and in version 2.1.19-1.3 of
cyrus-sasl2.

We recommend that you upgrade your libsasl packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20563-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 563-2 (cyrus-sasl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsasl-dev", ver:"1.5.27-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl-digestmd5-plain", ver:"1.5.27-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl-modules-plain", ver:"1.5.27-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsasl7", ver:"1.5.27-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sasl-bin", ver:"1.5.27-3woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
