# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 586-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53279);
 script_bugtraq_id(11618);
 script_cve_id("CVE-2004-0983");
 script_version ("$");
 name = "Debian Security Advisory DSA 586-1 (ruby)";
 script_name(name);

 desc = "The remote host is missing an update to ruby
announced via advisory DSA 586-1.

The upstream developers of Ruby have corrected a problem in the CGI
module for this language.  Specially crafted requests could cause an
infinite loop and thus cause the program to eat up cpu cycles.

For the stable distribution (woody) this problem has been fixed in
version ruby_1.6.7-3woody4.

For the unstable distribution (sid) this problem has been fixed in
version 1.6.8-12 of ruby1.6 and in version 1.8.1+1.8.2pre2-4 of
ruby1.8.

We recommend that you upgrade your ruby packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20586-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 586-1 (ruby)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"irb", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby-elisp", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby-examples", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurses-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnkf-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpty-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsdbm-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsyslog-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtk-ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby-dev", ver:"1.6.7-3woody4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
