# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 596-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53284);
 script_bugtraq_id(11668);
 script_cve_id("CVE-2004-1051");
 script_version ("$");
 name = "Debian Security Advisory DSA 596-1 (sudo)";
 script_name(name);

 desc = "The remote host is missing an update to sudo
announced via advisory DSA 596-1.

Liam Helmer noticed that sudo, a program that provides limited super
user privileges to specific users, does not clean the environment
sufficiently.  Bash functions and the CDPATH variable are still passed
through to the program running as privileged user, leaving
possibilities to overload system routines.  These vulnerabilities can
only be exploited by users who have been granted limited super user
privileges.

For the stable distribution (woody) these problems have been fixed in
version 1.6.6-1.2.

For the unstable distribution (sid) these problems have been fixed in
version 1.6.8p3.

We recommend that you upgrade your sudo package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20596-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 596-1 (sudo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.6-1.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
