# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 626-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53465);
 script_bugtraq_id(12173);
 script_cve_id("CVE-2004-1183");
 script_version ("$");
 name = "Debian Security Advisory DSA 626-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 626-1.

Dmitry V. Levin discovered a buffer overflow in libtiff, the Tag Image
File Format library for processing TIFF graphics files.  Upon reading
a TIFF file it is possible to crash the application, and maybe also to
execute arbitrary code.

For the stable distribution (woody) this problem has been fixed in
version 3.5.5-6.woody5.

For the unstable distribution (sid) this problem has been fixed in
version 3.6.1-5.

We recommend that you upgrade your libtiff package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20626-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 626-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.5.5-6.woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g", ver:"3.5.5-6.woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g-dev", ver:"3.5.5-6.woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
