# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 641-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53476);
 script_bugtraq_id(12274);
 script_cve_id("CVE-2005-0020");
 script_version ("$");
 name = "Debian Security Advisory DSA 641-1 (playmidi)";
 script_name(name);

 desc = "The remote host is missing an update to playmidi
announced via advisory DSA 641-1.

Erik Sjlund discovered that playmidi, a MIDI player, contains a
setuid root program with a buffer overflow that can be exploited by a
local attacker.

For the stable distribution (woody) this problem has been fixed in
version 2.4-4woody1.

For the unstable distribution (sid) this problem has been fixed in
version 2.4debian-3.

We recommend that you upgrade your playmidi package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20641-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 641-1 (playmidi)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"playmidi", ver:"2.4-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
