# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 757-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54373);
 script_cve_id("CVE-2005-1689", "CVE-2005-1174", "CVE-2005-1175");
 script_version ("$");
 name = "Debian Security Advisory DSA 757-1 (krb5)";
 script_name(name);

 desc = "The remote host is missing an update to krb5
announced via advisory DSA 757-1.

Daniel Wachdorf reported two problems in the MIT krb5 distribution used
for network authentication. First, the KDC program from the krb5-kdc
package can corrupt the heap by trying to free memory which has already
been freed on receipt of a certain TCP connection. This vulnerability
can cause the KDC to crash, leading to a denial of service.
[CVE-2005-1174] Second, under certain rare circumstances this type of
request can lead to a buffer overflow and remote code execution.
[CVE-2005-1175]

Additionally, Magnus Hagander reported another problem in which the
krb5_recvauth function can in certain circumstances free previously
freed memory, potentially leading to the execution of remote code.
[CVE-2005-1689]

All of these vulnerabilities are believed difficult to exploit, and no
exploits have yet been discovered.

For the old stable distribution (woody), these problems have been fixed
in version 1.2.4-5woody10. Note that woody's KDC does not have TCP
support and is not vulnerable to CVE-2005-1174.

For the stable distribution (sarge), these problems have been fixed in
version 1.3.6-2sarge2.

For the unstable distribution (sid), these problems have been fixed in
version 1.3.6-4.

We recommend that you upgrade your krb5 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20757-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 757-1 (krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.2.4-5woody10", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.3.6-2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
