# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 774-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55047);
 script_cve_id("CVE-2005-2335");
 script_bugtraq_id(14349);
 script_version ("$");
 name = "Debian Security Advisory DSA 774-1 (fetchmail)";
 script_name(name);

 desc = "The remote host is missing an update to fetchmail
announced via advisory DSA 774-1.

Edward Shornock discovered a bug in the UIDL handling code of
fetchmail, a common POP3, APOP and IMAP mail fetching utility.  A
malicious POP3 server could exploit this problem and inject arbitrary
code that will be executed on the victim host.  If fetchmail is
running as root, this becomes a root exploit.

the old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 6.2.5-12sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 6.2.5-16.

We recommend that you upgrade your fetchmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20774-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 774-1 (fetchmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fetchmail-ssl", ver:"6.2.5-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.2.5-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"6.2.5-12sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
