# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 797-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55485);
 script_cve_id("CVE-2005-1849", "CVE-2005-2096");
 script_version ("$");
 name = "Debian Security Advisory DSA 797-2 (zsync)";
 script_name(name);

 desc = "The remote host is missing an update to zsync
announced via advisory DSA 797-2.

zsync, a file transfer program, includes a modified local copy of
the zlib library, and is vulnerable to certain bugs fixed previously
in the zlib package.

There was a build error for the sarge i386 proftpd packages released in
DSA 797-1. A new build, zsync_0.3.3-1.sarge.1.2, has been prepared to
correct this error. The packages for other architectures are unaffected.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20797-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 797-2 (zsync)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zsync", ver:"0.3.3-1.sarge.1.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
