# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 803-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55259);
 script_bugtraq_id(15647, 14106);
 script_cve_id("CVE-2005-2088");
 script_version ("$");
 name = "Debian Security Advisory DSA 803-1 (apache)";
 script_name(name);

 desc = "The remote host is missing an update to apache
announced via advisory DSA 803-1.

A vulnerability has been discovered in the Apache web server.  When it
is acting as an HTTP proxy, it allows remote attackers to poison the
web cache, bypass web application firewall protection, and conduct
cross-site scripting attacks, which causes Apache to incorrectly
handle and forward the body of the request.

For the old stable distribution (woody) this problem has been fixed in
version 1.3.26-0woody7.

For the stable distribution (sarge) this problem has been fixed in
version 1.3.33-6sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 1.3.33-8.

We recommend that you upgrade your Apache package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20803-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 803-1 (apache)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.26-0woody7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.26-0woody7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.26-0woody7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.26-0woody7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-utils", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dbg", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-perl", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-ssl", ver:"1.3.33-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-perl", ver:"1.29.0.3-6sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
