# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 851-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55602);
 script_cve_id("CVE-2005-2531", "CVE-2005-2532", "CVE-2005-2533", "CVE-2005-2534");
 script_version ("$");
 name = "Debian Security Advisory DSA 851-1 (openvpn)";
 script_name(name);

 desc = "The remote host is missing an update to openvpn
announced via advisory DSA 851-1.

Several security related problems have been discovered in openvpn, a
Virtual Private Network daemon.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2531
Wrong processing of failed certificate authentication when running
with verb 0 and without TLS authentication can lead to a denial
of service by disconnecting the wrong client.

CVE-2005-2532
Wrong handling of packets that can't be decrypted on the server
can lead to the disconnection of unrelated clients.

CVE-2005-2533
When running in dev tap Ethernet bridging mode, openvpn can
exhaust its memory by receiving a large number of spoofed MAC
addresses and hence denying service.

CVE-2005-2534
Simultaneous TCP connections from multiple clients with the same
client certificate can cause a denial of service when
--duplicate-cn is not enabled.

The old stable distribution (woody) does not contain openvpn packages.

For the stable distribution (sarge) these problems have been fixed in
version 2.0-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 2.0.2-1.

We recommend that you upgrade your openvpn package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20851-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 851-1 (openvpn)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openvpn", ver:"2.0-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
