# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 894-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55875);
 script_cve_id("CVE-2005-2964", "CVE-2005-2972");
 script_version ("$");
 name = "Debian Security Advisory DSA 894-1 (abiword)";
 script_name(name);

 desc = "The remote host is missing an update to abiword
announced via advisory DSA 894-1.

Chris Evans discoverd several buffer overflows in the RTF import
mechanism of AbiWord, a WYSIWYG word processor based on GTK 2.
Opening a specially crafted RTF file could lead to the execution of
arbitrary code.

For the old stable distribution (woody) these problems have been fixed in
version 1.0.2+cvs.2002.06.05-1woody3.

For the stable distribution (sarge) these problems have been fixed in
version 2.2.7-3sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 2.2.10-1.

We recommend that you upgrade your abiword package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20894-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 894-1 (abiword)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"abiword-doc", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-abi", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-common", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-gnome", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-gtk", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-plugins", ver:"1.0.2+cvs.2002.06.05-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-common", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-doc", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-help", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xfonts-abi", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-gnome", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-plugins", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abiword-plugins-gnome", ver:"2.2.7-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
