# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 913-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55944);
 script_cve_id("CVE-2005-2975", "CVE-2005-2976", "CVE-2005-3186");
 script_bugtraq_id(15428);
 script_version ("$");
 name = "Debian Security Advisory DSA 913-1 (gdk-pixbuf)";
 script_name(name);

 desc = "The remote host is missing an update to gdk-pixbuf
announced via advisory DSA 913-1.

Several vulnerabilities have been found in gdk-pixbuf, the Gtk+
GdkPixBuf XPM image rendering library.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2975

Ludwig Nussel discovered an infinite loop when processing XPM
images that allows an attacker to cause a denial of service via a
specially crafted XPM file.

CVE-2005-2976

Ludwig Nussel discovered an integer overflow in the way XPM images
are processed that could lead to the execution of arbitrary code
or crash the application via a specially crafted XPM file.

CVE-2005-3186

infamous41md discovered an integer in the XPM processing routine
that can be used to execute arbitrary code via a traditional heap
overflow.

The following matrix explains which versions fix these problems:

old stable (woody)    stable (sarge)   unstable (sid)
gdk-pixbuf     0.17.0-2woody3        0.22.0-8.1       0.22.0-11
gtk+2.0         2.0.2-5woody3         2.6.4-3.1        2.6.10-2

We recommend that you upgrade your gdk-pixbuf packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20913-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 913-1 (gdk-pixbuf)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgdk-pixbuf-dev", ver:"0.17.0-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome-dev", ver:"0.17.0-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome2", ver:"0.17.0-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf2", ver:"0.17.0-2woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-dev", ver:"0.22.0-8.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome-dev", ver:"0.22.0-8.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome2", ver:"0.22.0-8.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf2", ver:"0.22.0-8.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
