# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 937-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56142);
 script_cve_id("CVE-2005-3191", "CVE-2005-3192", "CVE-2005-3624", "CVE-2005-3625", "CVE-2005-3626", "CVE-2005-3627", "CVE-2005-3628");
 script_version ("$");
 name = "Debian Security Advisory DSA 937-1 (tetex-bin)";
 script_name(name);

 desc = "The remote host is missing an update to tetex-bin
announced via advisory DSA 937-1.

infamous41md and Chris Evans discovered several heap based buffer
overflows in xpdf, the Portable Document Format (PDF) suite, which is
also present in tetex-bin, the binary files of teTeX, and which can
lead to a denial of service by crashing the application or possibly to
the execution of arbitrary code.

For the old stable distribution (woody) these problems have been fixed in
version 1.0.7+20011202-7.7.

For the stable distribution (sarge) these problems have been fixed in
version 2.0.2-30sarge4.

For the unstable distribution (sid) these problems have been fixed in
version 0.4.3-2 of poppler against which tetex-bin links.

We recommend that you upgrade your tetex-bin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20937-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 937-1 (tetex-bin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"1.0.7+20011202-7.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkpathsea3", ver:"1.0.7+20011202-7.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tetex-bin", ver:"1.0.7+20011202-7.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"2.0.2-30sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkpathsea3", ver:"2.0.2-30sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tetex-bin", ver:"2.0.2-30sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
