# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 946-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56192);
 script_cve_id("CVE-2005-4158", "CVE-2006-0151");
 script_version ("$");
 name = "Debian Security Advisory DSA 946-1 (sudo)";
 script_name(name);

 desc = "The remote host is missing an update to sudo
announced via advisory DSA 946-1.

It has been discovered that sudo, a privileged program, that provides
limited super user privileges to specific users, passes several
environment variables to the program that runs with elevated
privileges.  In the case of include paths (e.g. for Perl, Python, Ruby
or other scripting languages) this can cause arbitrary code to be
executed as privileged user if the attacker points to a manipulated
version of a system library.

This update alters the former behaviour of sudo and limits the number
of supported environment variables to LC_*, LANG, LANGUAGE and TERM.
Additional variables are only passed through when set as env_check in
/etc/sudoers, which might be required for some scripts to continue to
work.

For the old stable distribution (woody) this problem has been fixed in
version 1.6.6-1.5.

For the stable distribution (sarge) this problem has been fixed in
version 1.6.8p7-1.3.

For the unstable distribution (sid) this problem has been fixed in
version 1.6.8p12-1.

We recommend that you upgrade your sudo package.  For unstable

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20946-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 946-1 (sudo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"sudo", ver:"1.6.6-1.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sudo", ver:"1.6.8p7-1.3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
