# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 986-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56359);
 script_cve_id("CVE-2006-0645");
 script_bugtraq_id(16568);
 script_version ("$");
 name = "Debian Security Advisory DSA 986-1 (gnutls11)";
 script_name(name);

 desc = "The remote host is missing an update to gnutls11
announced via advisory DSA 986-1.

Evgeny Legerov discovered several out-of-bounds memory accesses in the
DER decoding component component of the Tiny ASN.1 Library, which is
also present and used in GnuTLS, the GNU implementation for Transport
Layer Security (TLS) 1.0 and Secure Sockets Layer (SSL) 3.0 protocols
and which allows attackers to crash the DER decoder and possibly
execute arbitrary code.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 1.0.16-13.2.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your gnutls packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20986-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 986-1 (gnutls11)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnutls-bin", ver:"1.0.16-13.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11", ver:"1.0.16-13.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11-dbg", ver:"1.0.16-13.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgnutls11-dev", ver:"1.0.16-13.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
