###############################################################################
# OpenVAS Vulnerability Test
# $Id: ePO_console_detect.nasl 5773 2009-11-01 16:45:48Z mime $
#
# ePO console Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running an ePolicy Orchestrator (ePo) console.

Risk factor : None";

if (description)
{
 script_id(100331);
 script_version ("1.0-$Revision: 5773 $");

 script_name("ePO console Detection");
 script_description(desc);
 script_summary("Checks for the presence of ePO console");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

 data = "xxxxx";

 req = string("POST /spipe/pkg?Source=Agent_3.0.0 HTTP/1.0\r\n",
	      "Content-Length: ", strlen(data),
              "\r\n",
              "\r\n",
	       data);

 buf = http_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);

 if("202 OK" >< buf)
 {

       blen = strlen(buf);
       str  = substr(buf,blen-3); 

       if(hexstr(str) == "0d0a20") { 

         if(report_verbosity > 0) {
           security_note(port:port);
         }

       }	 
       exit(0);

 }
exit(0);

