# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0578 (boinc-client)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63325);
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-0578 (boinc-client)";
 script_name(name);

 desc = "The remote host is missing an update to boinc-client
announced via advisory FEDORA-2009-0578.

The Berkeley Open Infrastructure for Network Computing (BOINC) is an open-
source software platform which supports distributed computing, primarily in
the form of volunteer computing and desktop Grid computing.  It is well
suited for problems which are often described as trivially parallel.  BOINC
is the underlying software used by projects such as SETI@home, Einstein@Home,
ClimatePrediciton.net, the World Community Grid, and many other distributed
computing projects.

This package installs the BOINC client software, which will allow your
computer to participate in one or more BOINC projects, using your spare
computer time to search for cures for diseases, model protein folding, study
global warming, discover sources of gravitational waves, and many other types
of scientific and mathematical research.

Update Information:

- Fix security bug BZ#479664 - Update to 6.4.5

ChangeLog:

* Thu Jan 15 2009 Milos Jakubicek  - 6.4.5-2.20081217svn
- Fix security bug BZ#479664
* Wed Dec 17 2008 Milos Jakubicek  - 6.4.5-1.20081217svn
- Update to 6.4.5
- Updated boinc-gccflags.patch and boinc-locales.patch
- Not trimming doc/ subdirectory
- Bash completion now provided by the source tarball,
  not packaged as separate sources anymore.
- Supplied example /etc/sysconfig configuration file
- Added BR: docbook2X for autogenerating manpages, not packaged as separate
  sources anymore.

References:

[ 1 ] Bug #479664 - boinc-client: Does not check the RSA_public_decrypt() return value.
https://bugzilla.redhat.com/show_bug.cgi?id=479664

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update boinc-client' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0578

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0578 (boinc-client)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"boinc-client", rpm:"boinc-client~6.4.5~2.20081217svn.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-client-devel", rpm:"boinc-client-devel~6.4.5~2.20081217svn.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-manager", rpm:"boinc-manager~6.4.5~2.20081217svn.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-client-debuginfo", rpm:"boinc-client-debuginfo~6.4.5~2.20081217svn.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
