# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0943 (dia)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63286);
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-0943 (dia)";
 script_name(name);

 desc = "The remote host is missing an update to dia
announced via advisory FEDORA-2009-0943.

Update Information:

Filter out untrusted python modules search path to remove the possibility to run
arbitrary code on the user's system if there is a python file in dia's working
directory named the same as one that dia's python scripts try to import.

ChangeLog:

* Mon Jan 26 2009 Caoln McNamara  1:0.96.1-9
- Resolves: rhbz#481551 python modules search path
* Fri Oct 31 2008 Caoln McNamara  1:0.96.1-8
- kill the .las

References:

[ 1 ] Bug #481551 - dia: untrusted python modules search path
https://bugzilla.redhat.com/show_bug.cgi?id=481551

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update dia' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0943

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-0943 (dia)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dia", rpm:"dia~0.96.1~9.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dia-debuginfo", rpm:"dia-debuginfo~0.96.1~9.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
