# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10662 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66093);
 script_cve_id("CVE-2009-3615", "CVE-2009-2703", "CVE-2009-3083", "CVE-2009-3084", "CVE-2009-3085", "CVE-2009-2694");
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-10662 (pidgin)");

 desc = "The remote host is missing an update to pidgin
announced via advisory FEDORA-2009-10662.

Update Information: CVE-2009-3615

ChangeLog:

* Mon Oct 19 2009 Warren Togami  2.6.3-2
- Upstream backport:
3abad7606f4a2dfd1903df796f33924b12509a56 msn_servconn_disconnect-crash
* Fri Oct 16 2009 Warren Togami  2.6.3-1
- 2.6.3 CVE-2009-3615

References:

[ 1 ] Bug #529357 - CVE-2009-3615 Pidgin: Invalid pointer dereference (crash) after receiving contacts from SIM IM client
https://bugzilla.redhat.com/show_bug.cgi?id=529357

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pidgin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10662

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10662 (pidgin)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"finch", rpm:"finch~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-docs", rpm:"pidgin-docs~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.6.3~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
