# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1074 (sudo)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63324);
 script_cve_id("CVE-2009-0034");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1074 (sudo)";
 script_name(name);

 desc = "The remote host is missing an update to sudo
announced via advisory FEDORA-2009-1074.

Sudo (superuser do) allows a system administrator to give certain
users (or groups of users) the ability to run some (or all) commands
as root while logging all commands and arguments. Sudo operates on a
per-command basis.  It is not a replacement for the shell.  Features
include: the ability to restrict what commands a user may run on a
per-host basis, copious logging of each command (providing a clear
audit trail of who did what), a configurable timeout of the sudo
command, and the ability to use the same configuration file (sudoers)
on many different machines.

Update Information:

Fix for incorrect handling of groups in Runas_User

ChangeLog:

* Thu Jan 29 2009 Daniel Kopecek  1.6.9p17-5
- Fix for incorrect handling of groups in Runas_User

References:

[ 1 ] Bug #481720 - CVE-2009-0034 sudo: incorrect handling of groups in Runas_User
https://bugzilla.redhat.com/show_bug.cgi?id=481720

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update sudo' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1074

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1074 (sudo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p17~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo-debuginfo", rpm:"sudo-debuginfo~1.6.9p17~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
