# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12305 (tomcat-native)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66562);
 script_cve_id("CVE-2009-3555");
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-12305 (tomcat-native)");

 desc = "The remote host is missing an update to tomcat-native
announced via advisory FEDORA-2009-12305.

Update Information:

Update to 1.1.18, implementing a mitigation for CVE-2009-3555.
http://tomcat.apache.org/native-doc/miscellaneous/changelog-1.1.x.html
http://marc.info/?l=tomcat-dev&m=125900987921402&w=2
http://marc.info/?l=tomcat-dev&m=125874793414940&w=2
http://marc.info/?l=tomcat-user&m=125874793614950&w=2

ChangeLog:

* Tue Nov 24 2009 Ville Skytt  - 1.1.18-1
- Update to 1.1.18 (security; CVE-2009-3555).
* Wed Nov  4 2009 Ville Skytt  - 1.1.17-1
- Update to 1.1.17 (#532931).

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update tomcat-native' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12305

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-12305 (tomcat-native)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"tomcat-native", rpm:"tomcat-native~1.1.18~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat-native-debuginfo", rpm:"tomcat-native-debuginfo~1.1.18~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
