# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1256 (roundcubemail)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63327);
 script_cve_id("CVE-2009-0413");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-1256 (roundcubemail)";
 script_name(name);

 desc = "The remote host is missing an update to roundcubemail
announced via advisory FEDORA-2009-1256.

Update Information:

Upgrade to 0.2 stable.

Following security fix is included as well:
Common Vulnerabilities and Exposures assigned an identifier
CVE-2009-0413 to  the following vulnerability:

Cross-site scripting (XSS) vulnerability in RoundCube Webmail
(roundcubemail) 0.2 stable allows remote attackers to inject
arbitrary web script or HTML via the background attribute
embedded in an HTML e-mail message.

ChangeLog:

* Wed Feb  4 2009 Jon Ciesla  = 0.2-7.stable
- Patch for CVE-2009-0413, BZ 484052.
* Mon Jan  5 2009 Jon Ciesla  = 0.2-6.stable
- New upstream.
- Dropped two most recent patches, applied upstream.

References:

https://bugzilla.redhat.com/show_bug.cgi?id=484052
http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-0413
http://trac.roundcube.net/changeset/2245
http://www.securityfocus.com/bid/33372
http://secunia.com/advisories/33622
http://xforce.iss.net/xforce/xfdb/48129

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update roundcubemail' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1256

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-1256 (roundcubemail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"roundcubemail", rpm:"roundcubemail~0.2~7.stable.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
