# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13066 (ruby)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66503);
 script_cve_id("CVE-2009-1904", "CVE-2008-3790");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-13066 (ruby)");

 desc = "The remote host is missing an update to ruby
announced via advisory FEDORA-2009-13066.

Update Information:

Update to 1.8.6 p368    This package also fixes the build failure on arm
-gnueabi systems (bug 506233), and DOS vulnerability issue on BigDecimal method
(bug 504958, CVE-2009-1904)

ChangeLog:

* Mon Dec  7 2009 Mamoru Tasaka  - 1.8.6.386-2
- Patch for bigdecimal DOS issue (CVE-2009-1904, bug 504958)

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ruby' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13066

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-13066 (ruby)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-irb", rpm:"ruby-irb~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-mode", rpm:"ruby-mode~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-rdoc", rpm:"ruby-rdoc~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-ri", rpm:"ruby-ri~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-debuginfo", rpm:"ruby-debuginfo~1.8.6.368~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
