# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13381 (postgresql)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66569);
 script_cve_id("CVE-2009-4136", "CVE-2009-4034");
 script_version ("$Revision$");
 script_name("Fedora Core 12 FEDORA-2009-13381 (postgresql)");

 desc = "The remote host is missing an update to postgresql
announced via advisory FEDORA-2009-13381.

Update Information:

Update to latest upstream point releases

ChangeLog:

* Wed Dec 16 2009 Tom Lane  8.4.2-1
- Update to PostgreSQL 8.4.2, for various fixes described at
http://www.postgresql.org/docs/8.4/static/release-8-4-2.html
including two security issues
Related: #546321
Related: #547662
- Use -N not the obsolete -n in useradd call
Resolves: #495727
- Clean up specfile to eliminate rpmlint gripes, mainly by removing
no-longer-needed provisions for superseding rh-postgresql
- add sparc/sparc64 to multilib header support

References:

[ 1 ] Bug #546321 - CVE-2009-4136 postgresql: SQL privilege escalation via modifications to session-local state
https://bugzilla.redhat.com/show_bug.cgi?id=546321
[ 2 ] Bug #547662 - CVE-2009-4034 postgresql: incorrect verification of SSL certificates with NUL in name
https://bugzilla.redhat.com/show_bug.cgi?id=547662

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update postgresql' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13381

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-13381 (postgresql)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-python", rpm:"postgresql-python~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-tcl", rpm:"postgresql-tcl~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-debuginfo", rpm:"postgresql-debuginfo~8.4.2~1.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
