# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2882 (thunderbird)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63655);
 script_cve_id("CVE-2009-0040", "CVE-2009-0352", "CVE-2009-0353", "CVE-2009-0772", "CVE-2009-0774", "CVE-2009-0775", "CVE-2009-0355", "CVE-2009-0776");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-2882 (thunderbird)";
 script_name(name);

 desc = "The remote host is missing an update to thunderbird
announced via advisory FEDORA-2009-2882.

Update Information:

Several flaws were found in the processing of malformed HTML mail content. An
HTML mail message containing malicious content could cause Thunderbird to crash
or, potentially, execute arbitrary code as the user running Thunderbird.
(CVE-2009-0040, CVE-2009-0352, CVE-2009-0353, CVE-2009-0772, CVE-2009-0774,
CVE-2009-0775)    Several flaws were found in the way malformed content was
processed. An HTML mail message containing specially-crafted content could
potentially trick a Thunderbird user into surrendering sensitive information.
(CVE-2009-0355, CVE-2009-0776)    Note: JavaScript support is disabled by
default in Thunderbird. None of the above issues are exploitable unless
JavaScript is enabled.

ChangeLog:

* Fri Mar 20 2009 Christopher Aillon  - 2.0.0.21-1
- Update to 2.0.0.21
* Wed Jan  7 2009 Christopher Aillon  - 2.0.0.19-2
- Disable the crash dialog
* Mon Jan  5 2009 Christopher Aillon  2.0.0.19-1
- Update to 2.0.0.19

References:

[ 1 ] Bug #486355 - CVE-2009-0040 libpng arbitrary free() flaw
https://bugzilla.redhat.com/show_bug.cgi?id=486355
[ 2 ] Bug #483139 - CVE-2009-0352 Firefox layout crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483139
[ 3 ] Bug #483141 - CVE-2009-0353 Firefox javascript crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483141
[ 4 ] Bug #483143 - CVE-2009-0355 Firefox local file stealing with SessionStore
https://bugzilla.redhat.com/show_bug.cgi?id=483143
[ 5 ] Bug #488273 - CVE-2009-0772 Firefox 2 and 3 - Layout engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=488273
[ 6 ] Bug #488283 - CVE-2009-0774 Firefox 2 and 3 crashes in the JavaScript engine
https://bugzilla.redhat.com/show_bug.cgi?id=488283
[ 7 ] Bug #488287 - CVE-2009-0775 Firefox XUL Linked Clones Double Free Vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=488287
[ 8 ] Bug #488290 - CVE-2009-0776 Firefox XML data theft via RDFXMLDataSource and cross-domain redirect
https://bugzilla.redhat.com/show_bug.cgi?id=488290

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update thunderbird' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2882

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2882 (thunderbird)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"thunderbird", rpm:"thunderbird~2.0.0.21~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"thunderbird-debuginfo", rpm:"thunderbird-debuginfo~2.0.0.21~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
