# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2927 (postgresql)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63661);
 script_cve_id("CVE-2009-0922");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-2927 (postgresql)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql
announced via advisory FEDORA-2009-2927.

Update Information:

Update to PostgreSQL 8.3.7, for various fixes described at
http://www.postgresql.org/docs/8.3/static/release-8-3-7.html

ChangeLog:

* Sat Mar 21 2009 Tom Lane  8.3.7-1
- Update to PostgreSQL 8.3.7, for various fixes described at
http://www.postgresql.org/docs/8.3/static/release-8-3-7.html
notably the fix for CVE-2009-0922

References:

[ 1 ] Bug #488156 - CVE-2009-0922 postgresql: potential DoS due to conversion functions
https://bugzilla.redhat.com/show_bug.cgi?id=488156

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update postgresql' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2927

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2927 (postgresql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-python", rpm:"postgresql-python~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-tcl", rpm:"postgresql-tcl~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postgresql-debuginfo", rpm:"postgresql-debuginfo~8.3.7~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
