# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3868 (moin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63881);
 script_cve_id("CVE-2008-0781", "CVE-2008-3381", "CVE-2009-0260", "CVE-2009-0312");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-3868 (moin)";
 script_name(name);

 desc = "The remote host is missing an update to moin
announced via advisory FEDORA-2009-3868.

Update Information:

Update moin to 1.6.4. Fix the following CVEs: CVE-2008-0781 (again),
CVE-2008-3381, CVE-2009-0260, CVE-2009-0312. Fix AttachFile escaping problems,
upstream 1.7 changeset 5f51246a4df1 backported.
ChangeLog:

* Mon Apr 20 2009 Ville-Pekka Vainio  1.6.4-1
- Update to 1.6.4
- CVE-2008-3381 fixed upstream
- Re-fix CVE-2008-0781, upstream seems to have dropped the fix in 1.6,
used part of upstream 1.5 db212dfc58ef, backported upstream 1.7 5f51246a4df1
and 269a1fbc3ed7
- Fix CVE-2009-0260, patch from Debian etch
- Fix CVE-2009-0312
- Fix AttachFile escaping problems, backported upstream 1.7 5c4043e651b3

References:

[ 1 ] Bug #457362 - CVE-2008-3381 moin: XSS issue in the advanced search form
https://bugzilla.redhat.com/show_bug.cgi?id=457362
[ 2 ] Bug #481547 - CVE-2009-0260 moin: tachFile XSS issues
https://bugzilla.redhat.com/show_bug.cgi?id=481547
[ 3 ] Bug #432748 - CVE-2008-0781 MoinMoin multiple XSS in AttachFile action
https://bugzilla.redhat.com/show_bug.cgi?id=432748
[ 4 ] Bug #482791 - CVE-2009-0312 moin: XSS issue in antispam
https://bugzilla.redhat.com/show_bug.cgi?id=482791

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update moin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3868

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3868 (moin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"moin", rpm:"moin~1.6.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
