# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-4394 (ipsec-tools)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63994);
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-4394 (ipsec-tools)";
 script_name(name);

 desc = "The remote host is missing an update to ipsec-tools
announced via advisory FEDORA-2009-4394.

Update Information:

Minor version update from upstream fixing remote DoS.
ChangeLog:

* Tue May  5 2009 Tomas Mraz  - 0.7.2-1
- Update to a new upstream version

References:

[ 1 ] Bug #497990 - ipsec-tools: racoon NULL dereference in fragmentation code
https://bugzilla.redhat.com/show_bug.cgi?id=497990

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ipsec-tools' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-4394

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-4394 (ipsec-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.7.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ipsec-tools-debuginfo", rpm:"ipsec-tools-debuginfo~0.7.2~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
