# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5383 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64077);
 script_cve_id("CVE-2008-3528", "CVE-2008-3525", "CVE-2008-3831", "CVE-2008-2750", "CVE-2009-1439", "CVE-2009-1633");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-5383 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to the kernel
announced via advisory FEDORA-2009-5383.

Update Information:

Update to kernel 2.6.27.24:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.24
Includes ext4 bug fixes from Fedora 11.
Updates the atl2 network driver to version 2.0.5

ChangeLog:

* Wed May 20 2009 Chuck Ebbert   2.6.27.24-78.2.53
- Allow building the F-9 kernel on F-11.
* Wed May 20 2009 Chuck Ebbert   2.6.27.24-78.2.52
- ext4 fixes from Fedora 11:
linux-2.6-ext4-clear-unwritten-flag.patch
linux-2.6-ext4-fake-delalloc-bno.patch
linux-2.6-ext4-fix-i_cached_extent-race.patch
linux-2.6-ext4-prealloc-fixes.patch
* Wed May 20 2009 Chuck Ebbert  2.6.27.24-78.2.51
- Linux 2.6.27.24
- Dropped patches, merged upstream:
cifs-fix-unicode-string-area-word-alignment-2.6.27.patch
- Update atl2 driver to version 2.0.5

References:

[ 1 ] Bug #494275 - CVE-2009-1439 kernel: cifs: memory overwrite when saving nativeFileSystem field during mount
https://bugzilla.redhat.com/show_bug.cgi?id=494275
[ 2 ] Bug #496572 - CVE-2009-1633 kernel: cifs: fix potential buffer overruns when converting unicode strings sent by server
https://bugzilla.redhat.com/show_bug.cgi?id=496572

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5383

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-5383 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-devel", rpm:"kernel-kdump-devel~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-debuginfo", rpm:"kernel-kdump-debuginfo~2.6.27.24~78.2.53.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
