# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5583 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64103);
 script_cve_id("CVE-2009-1373", "CVE-2009-1374", "CVE-2009-1375", "CVE-2009-1376", "CVE-2008-2927");
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-5583 (pidgin)";
 script_name(name);

 desc = "The remote host is missing an update to pidgin
announced via advisory FEDORA-2009-5583.

Update Information:

This is a bugfix & security fix release of Pidgin.    The full ChangeLog is
available at http://developer.pidgin.im/wiki/ChangeLog    Details of the
security fixes included are available at http://www.pidgin.im/news/security/

ChangeLog:

* Wed May 20 2009 Stu Tomlinson  2.5.6-1
- 2.5.6
* Mon Apr 20 2009 Warren Togami  2.5.5-3
- F12+ removed krb4

References:

[ 1 ] Bug #500488 - CVE-2009-1373 pidgin file transfer buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=500488
[ 2 ] Bug #500490 - CVE-2009-1374 pidgin DoS when decrypting qq packets
https://bugzilla.redhat.com/show_bug.cgi?id=500490
[ 3 ] Bug #500491 - CVE-2009-1375 pidgin PurpleCircBuffer corruption
https://bugzilla.redhat.com/show_bug.cgi?id=500491
[ 4 ] Bug #500493 - CVE-2009-1376 pidgin incomplete fix for CVE-2008-2927
https://bugzilla.redhat.com/show_bug.cgi?id=500493

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pidgin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5583

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-5583 (pidgin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"finch", rpm:"finch~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-docs", rpm:"pidgin-docs~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.5.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
