# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6389 (drupal-views)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64232);
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-6389 (drupal-views)";
 script_name(name);

 desc = "The remote host is missing an update to drupal-views
announced via advisory FEDORA-2009-6389.

Update Information:

* Advisory ID: DRUPAL-SA-CONTRIB-2009-037 [0]
* Project: Views
* Versions: 6.x-2.x
* Date: 2009-June-10
* Security risk: Moderately critical
* Exploitable from: Remote
* Vulnerability: Cross Site Scripting (XSS), Access Bypass

ChangeLog:

* Thu Jun 11 2009 Jon Ciesla  - 6.x.2.6-1
- New upstream, fixes SA-CONTRIB-2009-037.
* Tue Feb 24 2009 Fedora Release Engineering  - 6.x.2.2-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild
* Thu Dec 18 2008 Jon Ciesla  - 6.x.2.2-1
- New upstream, fixes SA-2008-075.
* Tue Nov  4 2008 Jon Ciesla  - 6.x.2.1-1
- New upstream.

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update drupal-views' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6389

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6389 (drupal-views)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"drupal-views", rpm:"drupal-views~6.x.2.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
