# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6899 (rt3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64294);
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-6899 (rt3)";
 script_name(name);

 desc = "The remote host is missing an update to rt3
announced via advisory FEDORA-2009-6899.

ChangeLog:

* Fri Jun 19 2009 Ralf Corspius  - 3.8.2-8
- Address BZ #506885 (BZ #506236).
- Remove rt-3.4.1-I18N.diff.
* Fri Apr 24 2009 Ralf Corspius  - 3.8.2-7
- README.fedora.in: Add --dba root to rt-setup-database (BZ #488621).
- R: perl(XML::RSS) (BZ #496720).

References:

[ 1 ] Bug #506885 - rt3: privilege to edit 'RT at a Glance' unintentionally granted by ShowConfigTab right
https://bugzilla.redhat.com/show_bug.cgi?id=506885

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update rt3' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6899

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-6899 (rt3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-RT-Test", rpm:"perl-RT-Test~3.8.2~8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rt3", rpm:"rt3~3.8.2~8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rt3-mailgate", rpm:"rt3-mailgate~3.8.2~8.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
