# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6982 (poppler)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64302);
 script_cve_id("CVE-2008-2950", "CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0166", "CVE-2009-0799", "CVE-2009-0800", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183", "CVE-2009-1187", "CVE-2009-1188");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-6982 (poppler)";
 script_name(name);

 desc = "The remote host is missing an update to poppler
announced via advisory FEDORA-2009-6982.

Update Information:

An update to address jbig2-related security issues.

ChangeLog:

* Fri Jan 23 2009 Rex Dieter  - 0.8.7-2
- use backported jbig2_security patch from debian/ubuntu (#496943)
- poppler-data-0.2.1
- --enable-libjpeg (speed)
- track sonames
- patch to workaround okular rendering hyperlinks (#480357)

References:

[ 1 ] Bug #496943 - CVE-2009-0146 CVE-2009-0147 CVE-2009-0166 CVE-2009-0799 CVE-2009-0800 CVE-2009-1179 CVE-2009-1180 CVE-2009-1181 CVE-2009-1182 CVE-2009-1183 CVE-2009-1187 CVE-2009-1188 poppler various flaws [F9]
https://bugzilla.redhat.com/show_bug.cgi?id=496943

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update poppler' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6982

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-6982 (poppler)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"poppler", rpm:"poppler~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-devel", rpm:"poppler-devel~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-glib", rpm:"poppler-glib~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-glib-devel", rpm:"poppler-glib-devel~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt", rpm:"poppler-qt~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt-devel", rpm:"poppler-qt-devel~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt4", rpm:"poppler-qt4~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-qt4-devel", rpm:"poppler-qt4-devel~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-utils", rpm:"poppler-utils~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-debuginfo", rpm:"poppler-debuginfo~0.8.7~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
