# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7498 (mumbles)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64398);
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-7498 (mumbles)";
 script_name(name);

 desc = "The remote host is missing an update to mumbles
announced via advisory FEDORA-2009-7498.

Update Information:

- Security fix for Firefox plugin bug #479171

ChangeLog:

* Wed Jun 10 2009 Tim Waugh  0.4-11
- Rebuild the plugins at build time (bug #505070).
* Mon Jun  8 2009 John Anderson  - 0.4-10
- Fixed path to make mumbles run on x86_64 bug #479158
- Security fix for Firefox plugin bug #479171
- Added buildrequires to fix bug #481188

References:

[ 1 ] Bug #505070 - Fails to load plugins
https://bugzilla.redhat.com/show_bug.cgi?id=505070
[ 2 ] Bug #479158 - Fails on x86_64
https://bugzilla.redhat.com/show_bug.cgi?id=479158
[ 3 ] Bug #479171 - Unsafe shell usage
https://bugzilla.redhat.com/show_bug.cgi?id=479171
[ 4 ] Bug #481188 - Possible missing dependancy in rpm - python-setuptools
https://bugzilla.redhat.com/show_bug.cgi?id=481188

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mumbles' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7498

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-7498 (mumbles)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mumbles", rpm:"mumbles~0.4~11.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
