# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8288 (perl-Gtk2-MozEmbed)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64554);
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8288 (perl-Gtk2-MozEmbed)");

 desc = "The remote host is missing an update to perl-Gtk2-MozEmbed
announced via advisory FEDORA-2009-8288.

This module allows you to use the Mozilla embedding widget from Perl.

Update Information:

Update to new upstream Firefox version 3.0.13, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.13

Update also includes all packages depending on gecko-libs rebuilt against
new version of Firefox / XULRunner.

Note: Issues described in MFSA 2009-42 and MFSA 2009-43 were
previously addressed via rebase of the NSS packages.

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl-Gtk2-MozEmbed' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8288

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8288 (perl-Gtk2-MozEmbed)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-Gtk2-MozEmbed", rpm:"perl-Gtk2-MozEmbed~0.08~6.fc10.4", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Gtk2-MozEmbed", rpm:"perl-Gtk2-MozEmbed~debuginfo~0.08", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
