# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8324 (squid)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64705);
 script_cve_id("CVE-2009-2621", "CVE-2009-2622");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8324 (squid)");

 desc = "The remote host is missing an update to squid
announced via advisory FEDORA-2009-8324.

Update Information:

Fixes several denial of service issues which could allow an attacker
to stop the Squid service.  CVE-2009-2621, CVE-2009-2622

ChangeLog:

* Tue Aug  4 2009 Henrik Nordstrom  - 7:3.0.STABLE18-1
- Update to 3.0.STABLE18
* Sat Aug  1 2009 Henrik Nordstrom  - 7:3.0.STABLE17-3
- Squid Bug #2728: regression: assertion failed: http.cc:705: !eof
* Mon Jul 27 2009 Henrik Nordstrom  - 7:3.0.STABLE17-1
- Bug #514014, update to 3.0.STABLE17 fixing the denial of service issues
mentioned in Squid security advisory SQUID-2009_2.

References:

[ 1 ] Bug #514013 - CVE-2009-2621, CVE-2009-2622 squid: multiple vulnerabilities fixed in squid 3.0.STABLE17
https://bugzilla.redhat.com/show_bug.cgi?id=514013

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update squid' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8324

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8324 (squid)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"squid", rpm:"squid~3.0.STABLE18~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~3.0.STABLE18~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
