# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8350 (xerces-c)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64731);
 script_cve_id("CVE-2009-1885");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8350 (xerces-c)");

 desc = "The remote host is missing an update to xerces-c
announced via advisory FEDORA-2009-8350.

Update Information:

CVE-2009-1885
ChangeLog:

* Thu Aug  6 2009 Peter Lemenkov  2.8.0-5
- Fix CVE-2009-1885
* Mon Jul 27 2009 Fedora Release Engineering  - 2.8.0-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild
* Thu Feb 26 2009 Fedora Release Engineering  - 2.8.0-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #515515 - CVE-2009-1885 xerces-c, xerces-c27: Stack overflow when parsing recursive XML structures
https://bugzilla.redhat.com/show_bug.cgi?id=515515

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xerces-c' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8350

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8350 (xerces-c)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xerces-c", rpm:"xerces-c~2.8.0~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xerces-c-devel", rpm:"xerces-c-devel~2.8.0~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xerces-c-doc", rpm:"xerces-c-doc~2.8.0~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xerces-c-debuginfo", rpm:"xerces-c-debuginfo~2.8.0~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
