# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8647 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64703);
 script_cve_id("CVE-2009-2692", "CVE-2009-2406", "CVE-2009-2407", "CVE-2009-1895", "CVE-2009-1897", "CVE-2009-0065", "CVE-2008-5079");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8647 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-8647.

Update Information:

Fix sock_sendpage null pointer dereference. CVE-2009-2692.

ChangeLog:

* Fri Aug 14 2009 Kyle McMartin  2.6.27.29-170.2.79
- CVE-2009-2692: Fix sock sendpage NULL ptr deref.
* Fri Jul 31 2009 Chuck Ebbert   2.6.27.29-170.2.78
- The kernel package needs to override the new rpm %install behavior.
* Thu Jul 30 2009 Chuck Ebbert   2.6.27.29-170.2.77
- Linux 2.6.27.29
* Wed Jul 29 2009 Chuck Ebbert   2.6.27.29-170.2.75.rc1
- Linux 2.6.27.29-rc1 (CVE-2009-2406, CVE-2009-2407)
- Drop linux-2.6-netdev-r8169-avoid-losing-msi-interrupts.patch, now in -stable.
* Wed Jul 29 2009 Chuck Ebbert   2.6.27.28-170.2.74
- Don't bounce virtio_blk requests (#510304)

References:

[ 1 ] Bug #516949 - CVE-2009-2692 kernel: uninit op in SOCKOPS_WRAP() leads to privesc
https://bugzilla.redhat.com/show_bug.cgi?id=516949

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8647

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8647 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.29~170.2.79.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
