# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8684 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64707);
 script_cve_id("CVE-2009-2767", "CVE-2009-2692", "CVE-2009-1897", "CVE-2009-1895", "CVE-2009-2406", "CVE-2009-2407");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8684 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-8684.

Update Information:

Fix oops in clock_nanosleep syscall which allows an ordinary user to cause a
null ptr dereference in the kernel. CVE-2009-2767. Fixes BUG_ON() in the intel
gem page fault code breaking GNOME Shell.

ChangeLog:

* Sat Aug 15 2009 Kyle McMartin  2.6.29.6-217.2.8
- CVE-2009-2767: Fix clock_nanosleep NULL ptr deref.
* Fri Aug 14 2009 Kyle McMartin  2.6.29.6-217.2.7
- CVE-2009-2692: Fix sock sendpage NULL ptr deref.
* Thu Aug 13 2009 Kristian Hgsberg  - 2.6.29.6-217.2.6
- Backport 0e7ddf7e to fix bad BUG_ON() in i915 gem fence management
code.  Adds drm-i915-gem-bad-bug-on.patch, fixes #514091.
* Wed Aug 12 2009 John W. Linville  2.6.29.6-217.2.5
- iwlwifi: fix TX queue race
* Mon Aug 10 2009 Jarod Wilson  2.6.29.6-217.2.4
- Add tunable pad threshold support to lirc_imon
- Blacklist all iMON devices in usbhid driver so lirc_imon can bind
- Add new device ID to lirc_mceusb (#512483)
- Enable IR transceiver on the HD PVR

References:

[ 1 ] Bug #515867 - CVE-2009-2767 kernel: clock_nanosleep() with CLOCK_MONOTONIC_RAW NULL pointer dereference
https://bugzilla.redhat.com/show_bug.cgi?id=515867

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8684

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8684 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.29.6~217.2.8.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
