# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8794 (neon)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64713);
 script_cve_id("CVE-2009-2473");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-8794 (neon)");

 desc = "The remote host is missing an update to neon
announced via advisory FEDORA-2009-8794.

Update Information:

This update includes the latest release of neon, version 0.28.6.
This fixes two security issues:

* the billion laughs attack against expat could allow a Denial
  of Service attack by a malicious server.  (CVE-2009-2473)
* an embedded NUL byte in a certificate subject name could allow
  an undetected MITM attack against an SSL server if a trusted CA
  issues such a cert.

Several bug fixes are also included, notably:

* X.509v1 CA certificates are trusted by default
* Fix handling of some PKCS#12 certificates

ChangeLog:

* Wed Aug 19 2009 Joe Orton  0.28.6-1
- update to 0.28.6
* Fri May 29 2009 Joe Orton  0.28.4-1.1
- trust V1 CA certs by default (#502451)
* Fri Mar  6 2009 Joe Orton  0.28.4-1
- update to 0.28.4
* Mon Jan 19 2009 Joe Orton  0.28.3-3
- use install-p in make install (Robert Scheck, #226189)

References:

[ 1 ] Bug #502451 - X509v1 CA certificate is not trusted
https://bugzilla.redhat.com/show_bug.cgi?id=502451

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update neon' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8794

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8794 (neon)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"neon", rpm:"neon~0.28.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"neon-devel", rpm:"neon-devel~0.28.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"neon-debuginfo", rpm:"neon-debuginfo~0.28.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
