# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8804 (gupnp-igd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64718);
 script_cve_id("CVE-2009-2694");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8804 (gupnp-igd)");

 desc = "The remote host is missing an update to gupnp-igd
announced via advisory FEDORA-2009-8804.

Update Information:

pidgin upgrade to 2.6.0 for the CVE-2009-2694, insufficient input validation in
msn_slplink_process_msg().  2.6.0 has Voice and Video support via farsight2
(Fedora 11+ only) and numerous other bug fixes.

farsight2, libnice and gupnp-igd are version upgrades to make voice and
video actually work on Fedora 11.

ChangeLog:

* Thu Aug  6 2009 Warren Togami  - 0.1.3-3
- Fix macros that were there for no good reason.
* Fri Jul 24 2009 Fedora Release Engineering  - 0.1.3-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gupnp-igd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8804

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8804 (gupnp-igd)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gupnp-igd", rpm:"gupnp-igd~0.1.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gupnp-igd-devel", rpm:"gupnp-igd-devel~0.1.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gupnp-igd-debuginfo", rpm:"gupnp-igd-debuginfo~0.1.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
