# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9075 (dhcp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66252);
 script_cve_id("CVE-2009-0692", "CVE-2009-1892");
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-9075 (dhcp)");

 desc = "The remote host is missing an update to dhcp
announced via advisory FEDORA-2009-9075.

Update Information:

Do not require policycoreutils when installing dhcp or dhclient packages.  If
you have the package installed, the /sbin/restorecon program will be used by
dhclient-script and the dhcpd init script.    This update to the dhcp package
includes fixes for CVE-2009-0692 and CVE-2009-1892.
Note: CVE-2009-0692 had no security consequences on Fedora, thanks to the
use of FORTIFY_SOURCE

ChangeLog:

* Wed Aug 26 2009 David Cantrell  - 12:4.1.0p1-4
- Do not require policycoreutils for dhclient subpackage, fix restorecon
calls in postinstall scriptlets (#519479)
* Wed Aug 26 2009 David Cantrell  - 12:4.1.0p1-3
- Do not require policycoreutils for post scriptlet (#519479)
* Thu Aug  6 2009 David Cantrell  - 12:4.1.0p1-2
- Add /usr/lib[64]/pm-utils/sleep.d/56dhclient to handle suspend and
resume with active dhclient leases (#479639)
* Wed Aug  5 2009 David Cantrell  - 12:4.1.0p1-1
- Upgrade to dhcp-4.1.0p1, which is the official upstream release to fix
CVE-2009-0692
* Wed Aug  5 2009 David Cantrell  - 12:4.1.0-25
- Fix for CVE-2009-0692
- Fix for CVE-2009-1892 (#511834)
- Disable patch for #514828 since that fix is still in updates-testing
* Tue Aug  4 2009 David Cantrell  - 12:4.1.0-24
- Correct lease file format written by dhclient (#514828)

References:

[ 1 ] Bug #519479 - dhclient/dhcp policycoreutils dep
https://bugzilla.redhat.com/show_bug.cgi?id=519479
[ 2 ] Bug #511834 - CVE-2009-1892 dhcp: DoS/abort in some configs with client-identifier and hardware address host specifications
https://bugzilla.redhat.com/show_bug.cgi?id=511834

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update dhcp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9075

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9075 (dhcp)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dhclient", rpm:"dhclient~4.1.0p1~4.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp", rpm:"dhcp~4.1.0p1~4.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-devel", rpm:"dhcp-devel~4.1.0p1~4.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-debuginfo", rpm:"dhcp-debuginfo~4.1.0p1~4.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
