#
#VID 6d68618a-7199-11db-a2ad-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57578);
 script_cve_id("CVE-2006-5453", "CVE-2006-5454", "CVE-2006-5455");
 script_version ("$");
 name = "FreeBSD Ports: bugzilla, ja-bugzilla";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   bugzilla
   ja-bugzilla

CVE-2006-5453
Multiple cross-site scripting (XSS) vulnerabilities in Bugzilla 2.18.x
before 2.18.6, 2.20.x before 2.20.3, 2.22.x before 2.22.1, and 2.23.x
before 2.23.3 allow remote authenticated users to inject arbitrary web
script or HTML via (1) page headers using the H1, H2, and H3 HTML tags
in global/header.html.tmpl, (2) description fields of certain items in
various edit cgi scripts, and (3) the id parameter in
showdependencygraph.cgi.
CVE-2006-5454
Bugzilla 2.18.x before 2.18.6, 2.20.x before 2.20.3, 2.22.x before
2.22.1, and 2.23.x before 2.23.3 allow remote attackers to obtain (1)
the description of arbitrary attachments by viewing the attachment in
'diff' mode in attachment.cgi, and (2) the deadline field by viewing
the XML format of the bug in show_bug.cgi.
CVE-2006-5455
Cross-site request forgery (CSRF) vulnerability in editversions.cgi in
Bugzilla before 2.22.1 and 2.23.x before 2.23.3 allows user-assisted
remote attackers to create, modify, or delete arbitrary bug reports
via a crafted URL.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.bugzilla.org/security/2.18.5/
http://www.vuxml.org/freebsd/6d68618a-7199-11db-a2ad-000c6ec775d9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bugzilla, ja-bugzilla";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bugzilla");
if(!isnull(bver) && revcomp(a:bver, b:"2")>0 && revcomp(a:bver, b:"2.22.1")<0) {
    security_note(0, data:"Package bugzilla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-bugzilla");
if(!isnull(bver) && revcomp(a:bver, b:"2")>0 && revcomp(a:bver, b:"2.22.1")<0) {
    security_note(0, data:"Package ja-bugzilla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
