#
#VID b9ec7fe3-a38a-11de-9c6b-003048818f40
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID b9ec7fe3-a38a-11de-9c6b-003048818f40
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64928);
 script_cve_id("CVE-2009-3125", "CVE-2009-3165", "CVE-2009-3166");
 script_version ("$");
 script_name("FreeBSD Ports: bugzilla");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bugzilla

CVE-2009-3125
SQL injection vulnerability in the Bug.search WebService function in
Bugzilla 3.3.2 through 3.4.1, and 3.5, allows remote attackers to
execute arbitrary SQL commands via unspecified parameters.

CVE-2009-3165
SQL injection vulnerability in the Bug.create WebService function in
Bugzilla 2.23.4 through 3.0.8, 3.1.1 through 3.2.4, and 3.3.1 through
3.4.1 allows remote attackers to execute arbitrary SQL commands via
unspecified parameters.

CVE-2009-3166
token.cgi in Bugzilla 3.4rc1 through 3.4.1 places a password in a URL
at the beginning of a login session that occurs immediately after a
password reset, which allows context-dependent attackers to discover
passwords by reading (1) web-server access logs, (2) web-server
Referer logs, or (3) the browser history.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.bugzilla.org/security/3.0.8/
http://www.vuxml.org/freebsd/b9ec7fe3-a38a-11de-9c6b-003048818f40.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: bugzilla");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bugzilla");
if(!isnull(bver) && revcomp(a:bver, b:"3.3.1")>0 && revcomp(a:bver, b:"3.4.2")<0) {
    security_note(0, data:"Package bugzilla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
