#
#VID da5c4072-8082-11dd-9c8c-001c2514716c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID da5c4072-8082-11dd-9c8c-001c2514716c
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61615);
 script_cve_id("CVE-2008-1389");
 script_version ("$");
 name = "FreeBSD Ports: clamav";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   clamav
   clamav-devel

CVE-2008-1389
libclamav/chmunpack.c in the chm-parser in ClamAV before 0.94 allows
remote attackers to cause a denial of service (application crash) via
a malformed CHM file, related to an 'invalid memory access.'

Solution:
Update your system with the appropriate patches or
software upgrades.

https://wwws.clamav.net/bugzilla/show_bug.cgi?id=1089
http://www.vuxml.org/freebsd/da5c4072-8082-11dd-9c8c-001c2514716c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: clamav";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"clamav");
if(!isnull(bver) && revcomp(a:bver, b:"0.94")<0) {
    security_note(0, data:"Package clamav version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"clamav-devel");
if(!isnull(bver) && revcomp(a:bver, b:"20080902")<0) {
    security_note(0, data:"Package clamav-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
