#
#VID c0a269d5-3d16-11d9-8818-008088034841
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52295);
 script_bugtraq_id(11729);
 script_cve_id("CVE-2004-1013");
 script_version ("$");
 name = "FreeBSD Ports: cyrus-imapd";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: cyrus-imapd

CVE-2004-1013
The argument parser of the FETCH command in Cyrus IMAP Server 2.2.x
through 2.2.8 allows remote authenticated users to execute arbitrary
code via certain commands such as (1) 'body[p', (2) 'binary[p', or (3)
'binary[p') that cause an index increment error that leads to an
out-of-bounds memory corruption.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://security.e-matters.de/advisories/152004.html
http://www.vuxml.org/freebsd/c0a269d5-3d16-11d9-8818-008088034841.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: cyrus-imapd";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cyrus-imapd");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.17")<0) {
    security_note(0, data:"Package cyrus-imapd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.2")>=0 && revcomp(a:bver, b:"2.2.8")<=0) {
    security_note(0, data:"Package cyrus-imapd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
