#
#VID 35f6fdf8-a425-11d8-9c6d-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52444);
 script_cve_id("CVE-2002-1580");
 script_bugtraq_id(6298);
 script_version ("$");
 name = "FreeBSD Ports: cyrus";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: cyrus

CVE-2002-1580
Integer overflow in imapparse.c for Cyrus IMAP server 1.4 and 2.1.10
allows remote attackers to execute arbitrary code via a large length
value that facilitates a buffer overflow attack, a different
vulnerability than CVE-2002-1347.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=103886607825605
http://asg.web.cmu.edu/archive/message.php?mailbox=archive.info-cyrus&msg=19349
http://www.vuxml.org/freebsd/35f6fdf8-a425-11d8-9c6d-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: cyrus";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cyrus");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.17")<0) {
    security_note(0, data:"Package cyrus version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.1")>=0 && revcomp(a:bver, b:"2.1.11")<0) {
    security_note(0, data:"Package cyrus version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
