#
#VID b5fc63ad-c4c3-11da-9699-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56520);
 script_bugtraq_id(17310);
 script_cve_id("CVE-2006-1550");
 script_version ("$");
 name = "FreeBSD Ports: dia, dia-gnome";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   dia
   dia-gnome

CVE-2006-1550
Multiple buffer overflows in the xfig import code (xfig-import.c) in
Dia 0.87 and later before 0.95-pre6 allow user-complicit attackers to
have an unknown impact via a crafted xfig file, possibly involving an
invalid (1) color index, (2) number of points, or (3) depth.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/19469/
http://mail.gnome.org/archives/dia-list/2006-March/msg00149.html
http://www.vuxml.org/freebsd/b5fc63ad-c4c3-11da-9699-00123ffe8333.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: dia, dia-gnome";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"dia");
if(!isnull(bver) && revcomp(a:bver, b:"0.86_1")>0 && revcomp(a:bver, b:"0.94_6,1")<0) {
    security_note(0, data:"Package dia version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"dia-gnome");
if(!isnull(bver) && revcomp(a:bver, b:"0.86_1")>0 && revcomp(a:bver, b:"0.94_6,1")<0) {
    security_note(0, data:"Package dia-gnome version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
